package cn.kinyun.scrm.weixin.sdk.api.shop;

import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.ShopInfoResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;
import java.util.Map;

/**
 * @Desc 微信小商店api
 * @Author zhangjing
 * @Date 2021/12/31 2:57 下午
 * @Version 1.0
 * @see <a href="https://developers.weixin.qq.com/miniprogram/dev/platform-capabilities/business-capabilities/ministore/minishopopencomponent/API/store/get_store_info.html">小商店api</a>
 */
@Slf4j
@Component
public class WxShopAPI {

    @Autowired
    private RestTemplate restTemplate;

    /**
     * 店铺接口-获取基本信息 POST
     */
    @Value("${wx.shop.base.info}")
    private String shopBaseInfoUrl;

    /**
     * 店铺接口-获取基本信息
     *
     * @param accessToken 接口调用凭证
     * @return
     */
    public ShopInfoResp getShopInfo(@NonNull String accessToken) {
        log.info("getShopInfo");

        Preconditions.checkArgument(StringUtils.isNoneBlank(accessToken), "accessToken不能为空");

        ResponseEntity<ShopInfoResp> resp = null;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        // 构造请求体
        Map<String, Object> params = Maps.newHashMap();
        HttpEntity<Map<String, Object>> httpEntity = new HttpEntity<Map<String, Object>>(params, headers);

        // 发送请求
        String url = MessageFormat.format(shopBaseInfoUrl, accessToken);
        resp = restTemplate.postForEntity(url, httpEntity, ShopInfoResp.class);

        ShopInfoResp result = resp.getBody();
        log.info("getShopInfo result={}", result);
        WeixinException.isSuccess(result);
        return result;
    }

}
