/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.emoji;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class WxExpressionUtils {
    private static final String[] CODE = new String[]{"/::)", "/::~", "/::B", "/::|", "/:8-)", "/::<", "/::$", "/::X", "/::Z", "/::'(", "/::-|", "/::@", "/::P", "/::D", "/::O", "/::(", "/::+", "/:--b", "/::Q", "/::T", "/:,@P", "/:,@-D", "/::d", "/:,@o", "/::g", "/:|-)", "/::!", "/::L", "/::>", "/::,@", "/:,@f", "/::-S", "/:?", "/:,@x", "/:,@@", "/::8", "/:,@!", "/:!!!", "/:xx", "/:bye", "/:wipe", "/:dig", "/:handclap", "/:&-(", "/:B-)", "/:<@", "/:@>", "/::-O", "/:>-|", "/:P-(", "/::'|", "/:X-)", "/::*", "/:@x", "/:8*", "/:pd", "/:<W>", "/:beer", "/:basketb", "/:oo", "/:coffee", "/:eat", "/:pig", "/:rose", "/:fade", "/:showlove", "/:heart", "/:break", "/:cake", "/:li", "/:bome", "/:kn", "/:footb", "/:ladybug", "/:shit", "/:moon", "/:sun", "/:gift", "/:hug", "/:strong", "/:weak", "/:share", "/:v", "/:@)", "/:jj", "/:@@", "/:bad", "/:lvu", "/:no", "/:ok", "/:love", "/:<L>", "/:jump", "/:shake", "/:<O>", "/:circle", "/:kotow", "/:turn", "/:skip", "/:oY", "/:#-0", "/:hiphot", "/:kiss", "/:<&", "/:&>", "[Hey]", "[Facepalm]", "[Smirk]", "[Smart]", "[Concerned]", "[Yeah!]", "[\u767c]", "[Packet]", "[Blessing]", "[Tea]", "[Candle]", "[Pup]"};
    private static final String[] WORD = new String[]{"\u5fae\u7b11", "\u6487\u5634", "\u8272", "\u53d1\u5446", "\u5f97\u610f", "\u6d41\u6cea", "\u5bb3\u7f9e", "\u95ed\u5634", "\u7761", "\u5927\u54ed", "\u5c34\u5c2c", "\u53d1\u6012", "\u8c03\u76ae", "\u5472\u7259", "\u60ca\u8bb6", "\u96be\u8fc7", "\u9177", "\u51b7\u6c57", "\u6293\u72c2", "\u5410", "\u5077\u7b11", "\u53ef\u7231", "\u767d\u773c", "\u50b2\u6162", "\u9965\u997f", "\u56f0", "\u60ca\u6050", "\u6d41\u6c57", "\u61a8\u7b11", "\u5927\u5175", "\u594b\u6597", "\u5492\u9a82", "\u7591\u95ee", "\u5618", "\u6655", "\u6298\u78e8", "\u8870", "\u9ab7\u9ac5", "\u6572\u6253", "\u518d\u89c1", "\u64e6\u6c57", "\u62a0\u9f3b", "\u9f13\u638c", "\u7cd7\u5927\u4e86", "\u574f\u7b11", "\u5de6\u54fc\u54fc", "\u53f3\u54fc\u54fc", "\u54c8\u6b20", "\u9119\u89c6", "\u59d4\u5c48", "\u5feb\u54ed\u4e86", "\u9634\u9669", "\u4eb2\u4eb2", "\u5413", "\u53ef\u601c", "\u83dc\u5200", "\u897f\u74dc", "\u5564\u9152", "\u7bee\u7403", "\u4e52\u4e53", "\u5496\u5561", "\u996d", "\u732a\u5934", "\u73ab\u7470", "\u51cb\u8c22", "\u793a\u7231", "\u7231\u5fc3", "\u5fc3\u788e", "\u86cb\u7cd5", "\u95ea\u7535", "\u70b8\u5f39", "\u5200", "\u8db3\u7403", "\u74e2\u866b", "\u4fbf\u4fbf", "\u6708\u4eae", "\u592a\u9633", "\u793c\u7269", "\u62e5\u62b1", "\u5f3a", "\u5f31", "\u63e1\u624b", "\u80dc\u5229", "\u62b1\u62f3", "\u52fe\u5f15", "\u62f3\u5934", "\u5dee\u52b2", "\u7231\u4f60", "NO", "OK", "\u7231\u60c5", "\u98de\u543b", "\u8df3\u8df3", "\u53d1\u6296", "\u6004\u706b", "\u8f6c\u5708", "\u78d5\u5934", "\u56de\u5934", "\u8df3\u7ef3", "\u6325\u624b", "\u6fc0\u52a8", "\u8857\u821e", "\u732e\u543b", "\u5de6\u592a\u6781", "\u53f3\u592a\u6781", "\u563f\u54c8", "\u6342\u8138", "\u5978\u7b11", "\u673a\u667a", "\u76b1\u7709", "\u8036", "\u767c", "\u7ea2\u5305", "\u798f", "\u8336", "\u8721\u70db", "\u5c0f\u72d7"};
    private static final int COUNT;
    private static final String DECODE_REGEX;
    private static final Map<String, String> DECODE_MAP;
    private static final String ENCODE_REGEX;
    private static final Map<String, String> ENCODE_MAP;

    private WxExpressionUtils() {
    }

    private static String generateRegex(String ... array) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            String str = array[i];
            str = str.replaceAll("\\\\", "\\\\\\\\");
            str = str.replaceAll("\\|", "\\\\|");
            str = str.replaceAll("\\)", "\\\\)");
            str = str.replaceAll("\\(", "\\\\(");
            str = str.replaceAll("\\]", "\\\\]");
            str = str.replaceAll("\\[", "\\\\[");
            str = str.replaceAll("\\+", "\\\\+");
            str = str.replaceAll("\\?", "\\\\?");
            str = str.replaceAll("\\*", "\\\\*");
            str = str.replaceAll(Matcher.quoteReplacement("$"), Matcher.quoteReplacement("\\$"));
            builder.append(str);
            if (i == len - 1) continue;
            builder.append('|');
        }
        return builder.toString();
    }

    public static String replace(String source, String regex, Map<String, String> map) {
        if (source == null || source.trim().length() == 0) {
            return source;
        }
        if (source.length() > 0) {
            HashMap<String, String> tmpMap = new HashMap<String, String>();
            Pattern emoji = Pattern.compile(regex, 2);
            Matcher m = emoji.matcher(source);
            while (m.find()) {
                String key = m.group();
                String value = map.get(key);
                if (value == null) continue;
                tmpMap.put(key, value);
            }
            if (!tmpMap.isEmpty()) {
                for (Map.Entry entry : tmpMap.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    source = source.replace(key, value);
                }
            }
        }
        return source;
    }

    public static boolean contains(String source, String regex) {
        Pattern p;
        Matcher m;
        boolean result = false;
        if (source != null && source.length() > 0 && (m = (p = Pattern.compile(regex, 2)).matcher(source)).find()) {
            result = true;
        }
        return result;
    }

    public static String decode(String source) {
        return WxExpressionUtils.replace(source, DECODE_REGEX, DECODE_MAP);
    }

    public static String encode(String source) {
        return WxExpressionUtils.replace(source, ENCODE_REGEX, ENCODE_MAP);
    }

    public static boolean containsCode(String source) {
        return WxExpressionUtils.contains(source, DECODE_REGEX);
    }

    public static boolean containsWord(String source) {
        return WxExpressionUtils.contains(source, ENCODE_REGEX);
    }

    static {
        DECODE_MAP = new HashMap<String, String>();
        ENCODE_MAP = new HashMap<String, String>();
        COUNT = CODE.length;
        for (int i = 0; i < COUNT; ++i) {
            WxExpressionUtils.WORD[i] = "[" + WORD[i] + "]";
            DECODE_MAP.put(CODE[i], WORD[i]);
            ENCODE_MAP.put(WORD[i], CODE[i]);
        }
        DECODE_REGEX = WxExpressionUtils.generateRegex(CODE);
        ENCODE_REGEX = WxExpressionUtils.generateRegex(WORD);
    }
}

