/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.applet;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.CommitCodeReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.SetPrivacySettingReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.SubmitAuditReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.GetCodePrivacyInfoResp;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.LatestAuditStatusResp;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.SubmitAuditResp;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.UploadMediaResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class AppletCodeManageAPI {
    private static final Logger log = LoggerFactory.getLogger(AppletCodeManageAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.applet.code_management.commit_code}")
    private String commitCodeUrl;
    @Value(value="${wx.applet.code_management.getQrcode}")
    private String getQrCodeUrl;
    @Value(value="${wx.applet.code_management.submit_audit}")
    private String submitAuditUrl;
    @Value(value="${wx.applet.code_management.upload_media}")
    private String uploadMediaUrl;
    @Value(value="${wx.applet.code_management.get_latest_audit_status}")
    private String getLatestAuditStatusUrl;
    @Value(value="${wx.applet.code_management.release}")
    private String releaseUrl;
    @Value(value="${wx.applet.code_management.get_code_privacy_info}")
    private String getCodePrivacyInfoUrl;
    @Value(value="${wx.applet.code_management.set_privacy_setting}")
    private String setPrivacySettingUrl;
    private static final Set<String> images = Sets.newHashSet((Object[])new String[]{"png", "jpg", "jpeg", "gif"});
    private static final Set<String> videos = Sets.newHashSet((Object[])new String[]{"mp4"});

    public ErrorCode setPrivacySetting(@NonNull String accessToken, @NonNull SetPrivacySettingReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("setPrivacySetting with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.setPrivacySettingUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode commitCode(@NonNull String accessToken, @NonNull CommitCodeReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("commitCode with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.commitCodeUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public UploadMediaResp uploadMedia(@NonNull String accessToken, String fileName, File file) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("uploadMedia with fileName={}", (Object)fileName);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)fileName), (Object)"fileName\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((Objects.nonNull(file) && file.exists() ? 1 : 0) != 0, (Object)"file\u4e0d\u80fd\u4e3a\u7a7a");
        String extension = FilenameUtils.getExtension((String)fileName);
        if (images.contains(extension)) {
            Preconditions.checkArgument((file.length() <= 0x200000L ? 1 : 0) != 0, (Object)"\u56fe\u7247\u6587\u4ef6\u6700\u59272M");
        } else if (videos.contains(extension)) {
            Preconditions.checkArgument((file.length() <= 0xA00000L ? 1 : 0) != 0, (Object)"\u89c6\u9891\u6587\u4ef6\u6700\u592710M");
        } else {
            Preconditions.checkArgument((images.contains(extension) || videos.contains(extension) ? 1 : 0) != 0, (Object)"\u56fe\u7247\u652f\u6301PNG,JPEG,JPG,GIF\u683c\u5f0f,\u89c6\u9891\u652f\u6301MP4\u683c\u5f0f");
        }
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        FileSystemResource resource = new FileSystemResource(file);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"media", (Object)resource);
        param.add((Object)"filename", (Object)fileName);
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        String url = MessageFormat.format(this.uploadMediaUrl, accessToken);
        resp = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, UploadMediaResp.class, new Object[0]);
        UploadMediaResp result = (UploadMediaResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public LatestAuditStatusResp getLatestAuditStatus(@NonNull String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("getLatestAuditStatus");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        String url = MessageFormat.format(this.commitCodeUrl, accessToken);
        resp = this.restTemplate.getForEntity(url, LatestAuditStatusResp.class, new Object[0]);
        LatestAuditStatusResp result = (LatestAuditStatusResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode release(@NonNull String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("release");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)Maps.newHashMap(), (MultiValueMap)headers);
        String url = MessageFormat.format(this.releaseUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public void getQrCode(@NonNull String accessToken, @NonNull String path) throws IOException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        log.info("getQrCode with path={}", (Object)path);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotBlank((CharSequence)path)) {
            path = URLEncoder.encode(path, "UTF-8");
        }
        String url = MessageFormat.format(this.getQrCodeUrl, accessToken, path);
        ResponseEntity resp = this.restTemplate.getForEntity(url, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
    }

    public SubmitAuditResp submitAudit(@NonNull String accessToken, @NonNull SubmitAuditReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("submitAudit with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.submitAuditUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, SubmitAuditResp.class, new Object[0]);
        SubmitAuditResp result = (SubmitAuditResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public GetCodePrivacyInfoResp getCodePrivacyInfo(@NonNull String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        String url = MessageFormat.format(this.getCodePrivacyInfoUrl, accessToken);
        resp = this.restTemplate.getForEntity(url, GetCodePrivacyInfoResp.class, new Object[0]);
        GetCodePrivacyInfoResp result = (GetCodePrivacyInfoResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

