/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.applet;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.category.AddCategoryReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.category.DeleteCategoryReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.category.GetAllCategoriesResp;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.category.GetCategoryResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class AppletCategoryAPI {
    private static final Logger log = LoggerFactory.getLogger(AppletCategoryAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.applet.category.getAllCategories}")
    private String getAllCategoriesUrl;
    @Value(value="${wx.applet.category.getCategory}")
    private String getCategoryUrl;
    @Value(value="${wx.applet.category.addCategory}")
    private String addCategoryUrl;
    @Value(value="${wx.applet.category.deleteCategory}")
    private String deleteCategoryUrl;

    public GetAllCategoriesResp getAllCategories(@NonNull String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("getAllCategories with accessToken={}", (Object)accessToken);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        String url = MessageFormat.format(this.getAllCategoriesUrl, accessToken);
        ResponseEntity resp = this.restTemplate.getForEntity(url, GetAllCategoriesResp.class, new Object[0]);
        GetAllCategoriesResp result = (GetAllCategoriesResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public GetCategoryResp getCategory(@NonNull String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("getCategory with accessToken={}", (Object)accessToken);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        String url = MessageFormat.format(this.getCategoryUrl, accessToken);
        ResponseEntity resp = this.restTemplate.getForEntity(url, GetCategoryResp.class, new Object[0]);
        GetCategoryResp result = (GetCategoryResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode addCategory(@NonNull String accessToken, @NonNull AddCategoryReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("addCategory with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.addCategoryUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode deleteCategory(@NonNull String accessToken, @NonNull DeleteCategoryReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("deleteCategory with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.deleteCategoryUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

