/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.template;

import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 模板参数
 * 
 * @title TemplateParam
 * @desc 模板参数
 * @author yanmaoyuan
 * @date 2019年4月28日
 * @version 1.0
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class TemplateParam implements Serializable {

    private static final long serialVersionUID = 795610815399950727L;

    /**
     * 模板数据
     */
    private String value;

    /**
     * 模板内容字体颜色，不填默认为黑色。
     * 格式为:#173177
     */
    private String color;// 可选
}