package cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * @author Created by chenjiaqiang on 2022/01/18
 **/
@Data
public class ModifyDomainReq {

    @JsonProperty("action")
    private String action;

    @JsonProperty("requestdomain")
    private List<String> requestDomain;

    @JsonProperty("wsrequestdomain")
    private List<String> wsRequestDomain;

    @JsonProperty("uploaddomain")
    private List<String> uploadDomain;

    @JsonProperty("downloaddomain")
    private List<String> downloadDomain;

    @JsonProperty("udpdomain")
    private List<String> udpDomain;

    @JsonProperty("tcpdomain")
    private List<String> tcpDomain;

    public void validate(){
        Preconditions.checkArgument(StringUtils.isNoneBlank(action),"action不能为空");
        if (!action.equals("get")){
            Preconditions.checkArgument(requestDomain!=null,"requestDomain不能为空");
            Preconditions.checkArgument(wsRequestDomain!=null,"wsRequestDomain不能为空");
            Preconditions.checkArgument(uploadDomain!=null,"uploadDomain不能为空");
            Preconditions.checkArgument(downloadDomain!=null,"downloadDomain不能为空");
            Preconditions.checkArgument(udpDomain!=null,"udpDomain不能为空");
            Preconditions.checkArgument(tcpDomain!=null,"tcpDomain不能为空");
        }

    }
}
