package cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto.account;

import com.fasterxml.jackson.annotation.JsonAlias;
import lombok.Data;

/**
 * @author Created by chenjiaqiang on 2022/01/17
 **/
@Data
public class WxVerifyInfoDto {

    /**
     * 是否资质认证，若是，拥有微信认证相关的权限。
     */
    @JsonAlias("qualification_verify")
    private Boolean qualificationVerify;

    /**
     * 是否名称认证
     */
    @JsonAlias("naming_verify")
    private Boolean namingVerify;

    /**
     * 是否需要年审（qualification_verify == true 时才有该字段）
     */
    @JsonAlias("annual_review")
    private Boolean annualReview;

    /**
     * 年审开始时间，时间戳（qualification_verify == true 时才有该字段）
     */
    @JsonAlias("annual_review_begin_time")
    private Long annualReviewBeginTime;

    @JsonAlias("annual_review_end_time")
    private Long annualReviewEndTime;
}
