/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.resp;

import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import cn.kinyun.scrm.weixin.sdk.api.custom.WxCustomMsgAPI;
import com.fasterxml.jackson.annotation.JsonProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 客服向用户推送的小程序卡片
 * 
 * @title MiniProgramMsg
 * @desc 客服向用户推送的小程序卡片
 * @author yanmaoyuan
 * @date 2019年4月29日
 * @version 1.0
 * @see <a href="https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140547">客服接口-发消息</a>
 * @see WxCustomMsgAPI#checkCustomMsgType
 * @see WxMsgType#MiniProgramPage
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class MiniProgramMsg extends BaseRespMsg {

    private static final long serialVersionUID = 7052928273242605498L;

    /**
     * 小程序标题
     */
    private String title;

    /**
     * 小程序的appid，要求小程序的appid需要与公众号有关联关系
     */
    @JsonProperty("appid")
    private String appId;

    /**
     * 小程序的页面路径，跟app.json对齐，支持参数，比如pages/index/index?foo=bar
     */
    @JsonProperty("pagepath")
    private String pagePath;

    /**
     * 缩略图/小程序卡片图片的媒体ID，小程序卡片图片建议大小为520*416
     */
    @JsonProperty("thumb_media_id")
    private String thumbMediaId;

    public MiniProgramMsg() {
        this.msgType = WxMsgType.MiniProgramPage.getValue();
    }

    @Override
    public String toXml() {
        throw new UnsupportedOperationException("此类消息不支持以XML格式回复给用户");
    }
}