/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.media;

import cn.kinyun.scrm.weixin.sdk.enums.WxMediaType;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 素材上传结果
 * 
 * @title MediaResult
 * @desc 素材上传结果
 * @author yanmaoyuan
 * @date 2019年4月28日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class MediaResult extends ErrorCode {

    private static final long serialVersionUID = 7726397866788627275L;

    /**
     * 素材类型
     * 
     * 媒体文件类型，分别有图片（image）、语音（voice）、视频（video）和缩略图（thumb，主要用于视频与音乐格式的缩略图）
     * 
     * {@link WxMediaType}
     */
    @JsonProperty("type")
    private String type;

    /**
     * 素材ID
     */
    @JsonProperty("media_id")
    @JsonAlias({"mediaid", "mediaId"})
    private String mediaId;

    /**
     * 创建时间
     */
    @JsonProperty("created_at")
    private long createdAt;
}