/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.analysis.msg;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * @title UpstreamMsgDto
 * @author yanmaoyuan
 * @date 2019年9月25日
 * @version 1.0
 */
@Data
public class UpstreamMsgDto implements Serializable {

    private static final long serialVersionUID = -4804538314174338244L;

    /**
     * 数据的日期，需在begin_date和end_date之间
     */
    @JsonAlias("ref_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date refDate;

    /**
     * 消息类型，代表含义如下：1代表文字 2代表图片 3代表语音 4代表视频 6代表第三方应用消息（链接消息）
     */
    @JsonAlias("msg_type")
    private int msgType;

    /**
     * 上行发送了（向公众号发送了）消息的用户数
     */
    @JsonAlias("msg_user")
    private int msgUser;

    /**
     * 上行发送了消息的消息总数
     */
    @JsonAlias("msg_count")
    private int msgCount;
}