package cn.kinyun.scrm.weixin.sdk.api.applet;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.FastCreateReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.SearchStatusReq;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;
import java.util.Objects;

/**
 * @author zhangjing
 * @desc
 * @date 2022/1/18 9:30 上午
 */
@Slf4j
@Component
public class AppletRegisterAPI {

    @Autowired
    private RestTemplate restTemplate;

    /**
     * 代商家注册小程序-快速注册企业小程序 POST
     */
    @Value("${wx.applet.register.fast_register_create}")
    private String appletRegisterFastCreateListUrl;

    /**
     * 代商家注册小程序-查询创建任务状态 POST
     */
    @Value("${wx.applet.register.fast_register_search}")
    private String appletRegisterFastSearchListUrl;

    /**
     * 获取代码草稿列表
     *
     * @param componentAccessToken
     * @return
     */
    public ErrorCode fastCreate(@NonNull String componentAccessToken, @NonNull FastCreateReq req) {
        log.info("fastCreate with req={}", req);

        Preconditions.checkArgument(StringUtils.isNoneBlank(componentAccessToken), "componentAccessToken不能为空");
        Preconditions.checkArgument(Objects.nonNull(req), "req不能为空");

        ResponseEntity<ErrorCode> resp = null;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        // 构造请求体
        HttpEntity<FastCreateReq> httpEntity = new HttpEntity<>(req, headers);

        // 发送请求
        String url = MessageFormat.format(appletRegisterFastCreateListUrl, componentAccessToken);
        resp = restTemplate.postForEntity(url, httpEntity, ErrorCode.class);

        ErrorCode result = resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    /**
     * 查询创建任务状态
     *
     * @param componentAccessToken
     * @return
     */
    public ErrorCode searchStatus(@NonNull String componentAccessToken, @NonNull SearchStatusReq req) {
        log.info("searchStatus with req={}", req);

        Preconditions.checkArgument(StringUtils.isNoneBlank(componentAccessToken), "componentAccessToken不能为空");
        Preconditions.checkArgument(Objects.nonNull(req), "req不能为空");

        ResponseEntity<ErrorCode> resp = null;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        // 构造请求体
        HttpEntity<SearchStatusReq> httpEntity = new HttpEntity<>(req, headers);

        // 发送请求
        String url = MessageFormat.format(appletRegisterFastSearchListUrl, componentAccessToken);
        resp = restTemplate.postForEntity(url, httpEntity, ErrorCode.class);

        ErrorCode result = resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}
