/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.utils;

import cn.kinyun.scrm.weixin.sdk.entity.media.Attachment;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.apache.commons.io.IOUtils;

public class HttpClient {
    private static final int CONNECTION_TIMEOUT = 30000;
    private static final int READ_TIMEOUT = 30000;
    private static final String POST = "POST";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(String url, File file) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        HttpURLConnection http = null;
        StringBuffer bufferRes = new StringBuffer();
        try {
            String BOUNDARY = "----WebKitFormBoundaryiDGnV9zdZA1eM1yL";
            http = this.getHttpURLConnection(url);
            this.setHttpHeader(http, POST);
            http.setUseCaches(false);
            http.setRequestProperty("connection", "Keep-Alive");
            http.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            try (OutputStream out = null;
                 DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));){
                int bytes;
                out = new DataOutputStream(http.getOutputStream());
                byte[] end_data = ("\r\n--" + BOUNDARY + "--\r\n").getBytes();
                StringBuilder sb = new StringBuilder();
                sb.append("--");
                sb.append(BOUNDARY);
                sb.append("\r\n");
                sb.append("Content-Disposition: form-data;name=\"media\";filename=\"").append(file.getName()).append("\"\r\n");
                sb.append("Content-Type:application/octet-stream\r\n\r\n");
                byte[] data = sb.toString().getBytes();
                out.write(data);
                byte[] bufferOut = new byte[1024];
                while ((bytes = dataInputStream.read(bufferOut)) != -1) {
                    out.write(bufferOut, 0, bytes);
                }
                out.write("\r\n".getBytes());
                out.write(end_data);
                out.flush();
            }
            try (InputStream ins = http.getInputStream();
                 BufferedReader read = new BufferedReader(new InputStreamReader(ins, StandardCharsets.UTF_8));){
                String valueString;
                bufferRes = new StringBuffer();
                while ((valueString = read.readLine()) != null) {
                    bufferRes.append(valueString);
                }
            }
        }
        finally {
            if (http != null) {
                http.disconnect();
            }
        }
        return bufferRes.toString();
    }

    public Attachment download(String url) throws IOException {
        Attachment attachment = new Attachment();
        URL _url = new URL(url);
        HttpURLConnection http = (HttpURLConnection)_url.openConnection();
        this.setHttpHeader(http, "GET");
        if (http.getContentType().equalsIgnoreCase("text/plain")) {
            String valueString;
            InputStream in = http.getInputStream();
            BufferedReader read = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            StringBuilder bufferRes = new StringBuilder();
            while ((valueString = read.readLine()) != null) {
                bufferRes.append(valueString);
            }
            in.close();
            attachment.setErrCode(-1);
            attachment.setErrMsg(bufferRes.toString());
        } else if (http.getContentType().contains("application/json")) {
            String valueString;
            InputStream in = http.getInputStream();
            BufferedReader read = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            StringBuilder bufferRes = new StringBuilder();
            while ((valueString = read.readLine()) != null) {
                bufferRes.append(valueString);
            }
            in.close();
            String jsonString = bufferRes.toString();
            JSONObject result = JSONObject.parseObject((String)jsonString);
            if (result.containsKey((Object)"errcode") && result.getIntValue("errcode") != 0) {
                attachment.setErrCode(result.getInteger("errcode"));
                attachment.setErrMsg(result.getString("errmsg"));
            } else {
                attachment.setErrCode(-1);
                attachment.setErrMsg(jsonString);
            }
        } else {
            String ds = http.getHeaderField("Content-disposition");
            String fileName = "";
            if (ds.contains("attachment;")) {
                fileName = ds.substring(ds.indexOf("filename=") + 10, ds.length());
            } else if (ds.contains("form-data;")) {
                fileName = ds.substring(ds.indexOf("filename=\"") + 10, ds.length() - 1);
            }
            attachment.setFileName(fileName);
            attachment.setContentLength(http.getHeaderField("Content-Length"));
            attachment.setContentType(http.getHeaderField("Content-Type"));
            attachment.setInputStream(new ByteArrayInputStream(IOUtils.toByteArray((InputStream)http.getInputStream())));
        }
        http.disconnect();
        return attachment;
    }

    private HttpURLConnection getHttpURLConnection(String url) throws IOException {
        URL urlGet = new URL(url);
        HttpURLConnection con = (HttpURLConnection)urlGet.openConnection();
        return con;
    }

    private void setHttpHeader(HttpURLConnection httpUrlConnection, String method) throws IOException {
        httpUrlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        httpUrlConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/33.0.1750.146 Safari/537.36");
        httpUrlConnection.setDoOutput(true);
        httpUrlConnection.setDoInput(true);
        httpUrlConnection.setRequestMethod(method);
        httpUrlConnection.setConnectTimeout(30000);
        httpUrlConnection.setReadTimeout(30000);
        httpUrlConnection.setRequestProperty("Charsert", "UTF-8");
    }
}

