/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.enums;

import java.util.HashMap;
import java.util.Map;

public enum WxMsgType {
    Text("text"),
    Image("image"),
    Voice("voice"),
    Video("video"),
    ShortVideo("shortvideo"),
    Location("location"),
    Link("link"),
    Event("event"),
    Music("music"),
    News("news"),
    MpNews("mpnews"),
    MpVideo("mpvideo"),
    WxCard("wxcard"),
    MsgMenu("msgmenu"),
    MiniProgramPage("miniprogrampage"),
    TransferCustomerService("transfer_customer_service");

    private static final Map<String, WxMsgType> cache;
    private String value;

    public static WxMsgType get(String msgType) {
        return cache.get(msgType);
    }

    private WxMsgType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static WxMsgType fromMaterialType(String materialType) {
        switch (materialType) {
            case "news": {
                return MpNews;
            }
            case "video": {
                return Video;
            }
            case "text": {
                return Text;
            }
            case "image": {
                return Image;
            }
            case "voice": {
                return Voice;
            }
        }
        return null;
    }

    static {
        cache = new HashMap<String, WxMsgType>();
        for (WxMsgType e : WxMsgType.values()) {
            cache.put(e.getValue(), e);
        }
    }
}

