/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.shop;

import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.CategoryResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.UploadImgResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxShopUtilAPI {
    private static final Logger log = LoggerFactory.getLogger(WxShopUtilAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.shop.base.upload}")
    private String uploadPost;
    @Value(value="${wx.shop.base.category}")
    private String categoryPost;

    public UploadImgResp uploadImg(@NonNull String accessToken, @NonNull Integer uploadType, @NonNull Integer respType, String imgUrl, File file) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (uploadType == null) {
            throw new NullPointerException("uploadType is marked non-null but is null");
        }
        if (respType == null) {
            throw new NullPointerException("respType is marked non-null but is null");
        }
        log.info("uploadImg with uploadType={},respType={},imgUrl={}", new Object[]{uploadType, respType, imgUrl});
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((uploadType >= 0 && uploadType <= 1 ? 1 : 0) != 0, (Object)"uploadType\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u53d6\u503c\u4e3a[0,1]");
        Preconditions.checkArgument((respType >= 0 && respType <= 1 ? 1 : 0) != 0, (Object)"respType\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u53d6\u503c\u4e3a[0,1]");
        Preconditions.checkArgument((boolean)ObjectUtils.anyNotNull((Object[])new Object[]{imgUrl, file}), (Object)"imgUrl\u548cfile\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        if (file != null && StringUtils.isEmpty((CharSequence)imgUrl)) {
            FileSystemResource resource = new FileSystemResource(file);
            LinkedMultiValueMap param = new LinkedMultiValueMap();
            param.add((Object)"media", (Object)resource);
            String url = MessageFormat.format(this.uploadPost, accessToken, uploadType, respType);
            HttpEntity httpEntity = new HttpEntity((Object)param);
            resp = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, UploadImgResp.class, new Object[0]);
        } else {
            HashMap params = Maps.newHashMap();
            params.put("img_url", imgUrl);
            HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
            String url = MessageFormat.format(this.uploadPost, accessToken, uploadType, respType);
            resp = this.restTemplate.postForEntity(url, (Object)httpEntity, UploadImgResp.class, new Object[0]);
        }
        UploadImgResp result = (UploadImgResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public CategoryResp getCategory(@NonNull String accessToken, @NonNull Long fCatId) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (fCatId == null) {
            throw new NullPointerException("fCatId is marked non-null but is null");
        }
        log.info("getCategory with fCatId={}", (Object)fCatId);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(fCatId), (Object)"fCatId\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("f_cat_id", fCatId);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.categoryPost, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, CategoryResp.class, new Object[0]);
        CategoryResp result = (CategoryResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

