/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.applet;

import cn.kinyun.scrm.weixin.sdk.entity.applet.GenerateShortUrlLinkReq;
import cn.kinyun.scrm.weixin.sdk.entity.applet.GenerateShortUrlLinkResp;
import cn.kinyun.scrm.weixin.sdk.entity.applet.GenerateUrlLinkReq;
import cn.kinyun.scrm.weixin.sdk.entity.applet.GenerateUrlLinkResp;
import cn.kinyun.scrm.weixin.sdk.entity.applet.QrcodeCreateReq;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.sdk.utils.HttpsClient;
import cn.kinyun.scrm.weixin.sdk.utils.JsonUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import javax.net.ssl.HttpsURLConnection;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class AppletQrcodeAPI {
    private static final Logger log = LoggerFactory.getLogger(AppletQrcodeAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.get.unlimited.qrcode.url}")
    private String getUnlimitedQrcodeUrl;
    @Value(value="${wx.generate.url.link.url}")
    private String generateUrlLinkUrl;
    @Value(value="${wx.applet.generateShortLink.url}")
    private String generateShortLinkUrl;
    private static final String POST = "POST";
    private static final String QRCODE_DIR = "./qrcodeDir/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getUnlimitedQrcodeFile(@NonNull String accessToken, @NonNull QrcodeCreateReq req) throws Exception {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("getUnlimitedQRCode,req:{}", (Object)JsonUtil.obj2Str(req));
        String url = MessageFormat.format(this.getUnlimitedQrcodeUrl, accessToken);
        HttpsClient client = new HttpsClient();
        HttpsURLConnection https = client.getHttpsURLConnection(url);
        client.setHttpsHeader(https, POST, false, null, null, null);
        https.setRequestProperty("connection", "Keep-Alive");
        https.setRequestProperty("Content-Type", "application/json");
        OutputStream os = https.getOutputStream();
        os.write(JsonUtil.obj2Str(req).getBytes());
        https.connect();
        File dir = new File(QRCODE_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String fileName = QRCODE_DIR + req.getScene() + ".jpeg";
        File file = new File(fileName);
        InputStream in = https.getInputStream();
        try (FileOutputStream fos = new FileOutputStream(file);){
            byte[] bytes = new byte[1024];
            int len = in.read(bytes);
            do {
                fos.write(bytes, 0, len);
            } while ((len = in.read(bytes)) != -1);
        }
        finally {
            os.close();
        }
        return file;
    }

    public GenerateUrlLinkResp generateUrlLinkUrl(@NonNull String accessToken, @NonNull GenerateUrlLinkReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("generateUrlLinkUrl req:{}", (Object)req);
        String url = MessageFormat.format(this.generateUrlLinkUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, GenerateUrlLinkResp.class, new Object[0]);
        GenerateUrlLinkResp result = (GenerateUrlLinkResp)response.getBody();
        if (result != null) {
            WeixinException.isSuccess(result);
        }
        return result;
    }

    public GenerateShortUrlLinkResp generateShortLink(@NonNull String accessToken, @NonNull GenerateShortUrlLinkReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("generateShortLink req:{}", (Object)req);
        String url = MessageFormat.format(this.generateShortLinkUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, GenerateShortUrlLinkResp.class, new Object[0]);
        GenerateShortUrlLinkResp result = (GenerateShortUrlLinkResp)response.getBody();
        if (result != null) {
            WeixinException.isSuccess(result);
        }
        return result;
    }
}

