/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.applet;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.account.ChangeWxaSearchStatusReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.account.CheckWxVerifyNicknameReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.account.ModifyDomainReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.account.ModifyHeadImageReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.account.ModifySignatureReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.account.SetNicknameReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.account.SetWebViewDomainReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.account.CheckWxVerifyNicknameResp;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.account.GetBasicInfoResp;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.account.GetEffectiveJumpDomainResp;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.account.GetEffectiveServerDomainResp;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.account.ModifyDomainResp;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.account.SetNicknameResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class AppletAccountAPI {
    private static final Logger log = LoggerFactory.getLogger(AppletAccountAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.applet.account.basicInfo}")
    private String getBasicInfoUrl;
    @Value(value="${wx.applet.account.modifyDomain}")
    private String modifyDomainUrl;
    @Value(value="${wx.applet.account.getEffectiveServerDomain}")
    private String getEffectiveServerDomainUrl;
    @Value(value="${wx.applet.account.setWebViewDomain}")
    private String setWebViewDomainUrl;
    @Value(value="${wx.applet.account.checkWxVerifyNickname}")
    private String checkWxVerifyNicknameUrl;
    @Value(value="${wx.applet.account.setNickname}")
    private String setNicknameUrl;
    @Value(value="${wx.applet.account.modifyHeadImage}")
    private String modifyHeadImageUrl;
    @Value(value="${wx.applet.account.modifySignature}")
    private String modifySignatureUrl;
    @Value(value="${wx.applet.account.changeWxaSearchStatus}")
    private String changeWxaSearchStatusUrl;
    @Value(value="${wx.applet.account.getEffectiveJumpDomain}")
    private String getEffectiveJumpDomainUrl;

    public GetBasicInfoResp getBasicInfo(@NonNull String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("getBasicInfo with accessToken={}", (Object)accessToken);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        String url = MessageFormat.format(this.getBasicInfoUrl, accessToken);
        ResponseEntity resp = this.restTemplate.getForEntity(url, GetBasicInfoResp.class, new Object[0]);
        GetBasicInfoResp result = (GetBasicInfoResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ModifyDomainResp modifyDomain(@NonNull String accessToken, @NonNull ModifyDomainReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("modifyDomain with req={}", (Object)req);
        req.validate();
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.modifyDomainUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ModifyDomainResp.class, new Object[0]);
        ModifyDomainResp result = (ModifyDomainResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public GetEffectiveServerDomainResp getEffectiveServerDomain(@NonNull String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("getEffectiveServerDomain with accessToken={}", (Object)accessToken);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)"{}", (MultiValueMap)headers);
        String url = MessageFormat.format(this.getEffectiveServerDomainUrl, accessToken);
        ResponseEntity resp = this.restTemplate.postForEntity(url, (Object)httpEntity, GetEffectiveServerDomainResp.class, new Object[0]);
        GetEffectiveServerDomainResp result = (GetEffectiveServerDomainResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode setWebViewDomain(@NonNull SetWebViewDomainReq req, @NonNull String accessToken) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("setWebViewDomain with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.setWebViewDomainUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public CheckWxVerifyNicknameResp checkWxVerifyNickname(@NonNull String accessToken, @NonNull CheckWxVerifyNicknameReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("checkWxVerifyNickname with req={}", (Object)req);
        req.validate();
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.checkWxVerifyNicknameUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, CheckWxVerifyNicknameResp.class, new Object[0]);
        CheckWxVerifyNicknameResp result = (CheckWxVerifyNicknameResp)resp.getBody();
        log.info("checkWxVerifyNickname with result={}", resp.getBody());
        WeixinException.isSuccess(result);
        return result;
    }

    public SetNicknameResp setNickname(@NonNull SetNicknameReq req, @NonNull String accessToken) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("setNickname with req={}", (Object)req);
        req.validate();
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.setNicknameUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, SetNicknameResp.class, new Object[0]);
        SetNicknameResp result = (SetNicknameResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode modifyHeadImage(@NonNull String accessToken, @NonNull ModifyHeadImageReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("modifyHeadImage with req={}", (Object)req);
        req.validate();
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.modifyHeadImageUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode modifySignature(@NonNull String accessToken, @NonNull ModifySignatureReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("modifySignature with req={}", (Object)req);
        req.validate();
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.modifySignatureUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode changeWxaSearchStatus(@NonNull String accessToken, @NonNull ChangeWxaSearchStatusReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("changeWxaSearchStatus with req={}", (Object)req);
        req.validate();
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.changeWxaSearchStatusUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public GetEffectiveJumpDomainResp getEffectiveJumpDomain(@NonNull String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("getEffectiveJumpDomain, token:{}", (Object)accessToken);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)"{}", (MultiValueMap)headers);
        String url = MessageFormat.format(this.getEffectiveJumpDomainUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, GetEffectiveJumpDomainResp.class, new Object[0]);
        GetEffectiveJumpDomainResp result = (GetEffectiveJumpDomainResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

