/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.analysis;

import cn.kinyun.scrm.weixin.sdk.entity.analysis.AnalysisReq;
import cn.kinyun.scrm.weixin.sdk.entity.analysis.api.ApiSummary;
import cn.kinyun.scrm.weixin.sdk.entity.analysis.api.ApiSummaryHour;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import java.text.MessageFormat;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxApiAnalysisAPI {
    private static final Logger log = LoggerFactory.getLogger(WxApiAnalysisAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.analysis.getinterfacesummary}")
    private String wxAnalysisGetInterfaceSummary;
    @Value(value="${wx.analysis.getinterfacesummaryhour}")
    private String wxAnalysisGetInterfaceSummaryHour;

    public ApiSummary getApiSummary(@NonNull String accessToken, @NonNull AnalysisReq params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("get interface summary with params={}", (Object)params);
        String url = MessageFormat.format(this.wxAnalysisGetInterfaceSummary, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ApiSummary.class, new Object[0]);
        ApiSummary result = (ApiSummary)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ApiSummaryHour getApiSummaryHour(@NonNull String accessToken, @NonNull AnalysisReq params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("get interface summary hour with params={}", (Object)params);
        String url = MessageFormat.format(this.wxAnalysisGetInterfaceSummaryHour, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ApiSummaryHour.class, new Object[0]);
        ApiSummaryHour result = (ApiSummaryHour)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

