/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.account;

import cn.kinyun.scrm.weixin.sdk.entity.account.ShorturlResult;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.HashMap;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxShorturlAPI {
    private static final Logger log = LoggerFactory.getLogger(WxShorturlAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.shorturl}")
    private String wxShorturl;

    public ShorturlResult shorturl(@NonNull String accessToken, @NonNull String longUrl) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (longUrl == null) {
            throw new NullPointerException("longUrl is marked non-null but is null");
        }
        log.info("shorturl url={}", (Object)longUrl);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("action", "long2short");
        params.put("long_url", longUrl);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxShorturl, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ShorturlResult.class, new Object[0]);
        ShorturlResult result = (ShorturlResult)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

