/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api;

import cn.kinyun.scrm.weixin.sdk.entity.user.req.TagModReq;
import cn.kinyun.scrm.weixin.sdk.entity.user.resp.TagListResp;
import cn.kinyun.scrm.weixin.sdk.entity.user.resp.TagModResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import java.text.MessageFormat;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxTagAPI {
    private static final Logger log = LoggerFactory.getLogger(WxTagAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.tag.create}")
    private String wxTagCreate;
    @Value(value="${wx.tag.get}")
    private String wxTagGet;
    @Value(value="${wx.tag.update}")
    private String wxTagUpdate;
    @Value(value="${wx.tag.delete}")
    private String wxTagDelete;
    @Value(value="${wx.user.tage.get")
    private String wxUserTageGet;

    public TagModResp createTag(@NonNull String accessToken, @NonNull TagModReq tagModReq) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (tagModReq == null) {
            throw new NullPointerException("tagModReq is marked non-null but is null");
        }
        log.info("create tag with params={}", (Object)tagModReq);
        String url = MessageFormat.format(this.wxTagCreate, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)tagModReq, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, TagModResp.class, new Object[0]);
        TagModResp result = (TagModResp)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public TagModResp updateTag(@NonNull String accessToken, @NonNull TagModReq tagModReq) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (tagModReq == null) {
            throw new NullPointerException("tagModReq is marked non-null but is null");
        }
        log.info("update tag with params={}", (Object)tagModReq);
        String url = MessageFormat.format(this.wxTagUpdate, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)tagModReq, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, TagModResp.class, new Object[0]);
        TagModResp result = (TagModResp)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public TagModResp deleteTag(@NonNull String accessToken, @NonNull TagModReq tagModReq) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (tagModReq == null) {
            throw new NullPointerException("tagModReq is marked non-null but is null");
        }
        log.info("delete tag with params={}", (Object)tagModReq);
        String url = MessageFormat.format(this.wxTagDelete, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)tagModReq, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, TagModResp.class, new Object[0]);
        TagModResp result = (TagModResp)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public TagListResp getTagList(@NonNull String accessToken) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("get tag list.");
        String url = MessageFormat.format(this.wxUserTageGet, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, null, TagListResp.class, new Object[0]);
        TagListResp result = (TagListResp)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

