/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.utils;

/**
 * 回复消息XML建造器
 * 
 * @title MsgXmlBuilder
 * @desc 回复消息XML建造器
 * @author yanmaoyuan
 * @date 2019年4月25日
 * @version 1.0
 */
public class MsgXmlBuilder {

    private StringBuffer buffer;

    public MsgXmlBuilder() {
        buffer = new StringBuffer();
    }

    public MsgXmlBuilder(String content) {
        buffer = new StringBuffer(content);
    }

    /**
     * 追加字符串
     * 
     * @param str
     */
    public MsgXmlBuilder append(String str) {
        buffer.append(str);
        return this;
    }

    /**
     * 插入字符串
     * 
     * @param str
     */
    public MsgXmlBuilder insert(String str) {
        buffer.insert(0, str);
        return this;
    }

    /**
     * 在文本之外增加一层元素标签。
     * 
     * @param tag
     */
    public MsgXmlBuilder surroundWith(String tag) {
        StringBuffer sb = new StringBuffer(buffer.capacity() + tag.length() * 2 + 5);
        sb.append("<").append(tag).append(">");
        sb.append(buffer);
        sb.append("</").append(tag).append(">");
        buffer = sb;
        return this;
    }

    /**
     * 添加元素
     * 
     * @param name
     * @param text
     */
    public MsgXmlBuilder addTag(String name, String text) {
        if (text == null) {
            return this;
        }
        buffer.append("<").append(name).append(">");
        buffer.append(text);
        buffer.append("</").append(name).append(">");
        
        return this;
    }

    /**
     * 添加元素，并使用CDATA将内容包起来。
     * 
     * @param name
     * @param data
     */
    public MsgXmlBuilder addCData(String name, String data) {
        if (data == null) {
            return this;
        }
        buffer.append("<").append(name).append("><![CDATA[");
        buffer.append(data);
        buffer.append("]]></").append(name).append(">");
        
        return this;
    }

    @Override
    public String toString() {
        return buffer.toString();
    }
}