/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.enums;

/**
 * 授权作用域（scope）代表用户授权给第三方的接口权限，第三方应用需要向微信开放平台申请使用相应scope的权限后，使用文档所述方式让用户进行授权，经过用户授权，获取到相应access_token后方可对接口进行调用。
 * 
 * @title WxOAuthScope
 * @desc 微信授权作用域（scope）
 * @author yanmaoyuan
 * @date 2019年4月22日
 * @version 1.0
 */
public enum WxOAuthScope {

    /**
     * 获取用户的openid。
     * 
     * 获得授权后，可以调用这些接口。
     * 
     * /sns/oauth2/access_token
     * /sns/oauth2/refresh_token
     * /sns/auth
     */
    SNSAPI_BASE("snsapi_base"),

    /**
     * 登录授权
     */
    SNSAPI_LOGIN("snsapi_login"),

    /**
     * 获取用户信息。
     * 
     * /sns/userinfo
     */
    SNSAPI_USERINFO("snsapi_userinfo")
    
    ;

    /**
     * 授权作用域
     */
    private String value;
    
    private WxOAuthScope(String value) {
        this.value = value;
    }
    
    public String getValue() {
        return value;
    }
}