package cn.kinyun.scrm.weixin.sdk.entity.shop.req;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zhangjing
 * @date 2022/1/4 1:58 下午
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SkuGetListReq {

    /**
     * 必填, 小商店内部商品ID
     */
    @JsonProperty("product_id")
    private Long productId;

    /**
     * 非必填, 默认0:获取线上数据, 1:获取草稿数据
     */
    @JsonProperty("need_edit_sku")
    private Integer needEditSku;

    /**
     * 非必填, 默认0:获取草稿库存, 1:获取线上真实库存
     */
    @JsonProperty("need_real_stock")
    private Integer needRealStock;

}
