package cn.kinyun.scrm.weixin.sdk.entity.shop.req;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author zhangjing
 * @date 2022/1/5 6:23 下午
 */
@Data
public class CouponGetListReq {

    /**
     * 必填, 优惠券创建时间的搜索开始时间
     */
    @JsonProperty("start_create_time")
    private String startCreateTime;

    /**
     * 必填, 优惠券创建时间的搜索结束时间
     */
    @JsonProperty("end_create_time")
    private String endCreateTime;

    /**
     * 必填, 优惠券状态
     */
    private Integer status;

    /**
     * 必填, 第几页（最小填1）
     */
    private Integer page;

    /**
     * 必填, 每页数量(不超过200)
     */
    @JsonProperty("page_size")
    private Integer pageSize;

}
