package cn.kinyun.scrm.weixin.sdk.entity.shop.dto.spu;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Desc
 * @Author zhangjing
 * @Date 2021/12/31 5:35 下午
 * @Version 1.0
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class ValidInfoSpuResp {

    /**
     * 1-指定时间区间生效 2-指定天数生效（购买后N天内有效）
     */
    @JsonProperty("valid_type")
    private String validType;

    /**
     * valid_type为2时必填，核销商品的有效天数，从订单付款完成开始计算，自动取整为结束当天23:59:59。最小值为1，最大值为365。
     */
    @JsonProperty("valid_day_num")
    private Integer validDayNum;

    /**
     * valid_type为1时必填，核销商品开始生效的日期。商品的实际生效时间根据该参数传入的时间戳自动取整为当天00:00:00。
     */
    @JsonProperty("start_time")
    private Long startTime;

    /**
     * valid_type为1时必填，核销商品失效的日期。商品的实际失效时间根据该参数传入的时间戳自动取整为当天23:59:59。可接受的最大值为调用接口的时间戳+365天。
     */
    @JsonProperty("end_time")
    private Long endTime;
}
