package cn.kinyun.scrm.weixin.sdk.entity.shop.dto;

import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.spu.CouponCodeInfoResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SpuAddReq;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author zhangjing
 * @date 2022/1/4 10:02 上午
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SpuItemDto {
    /**
     * 小商店内部商品ID
     */
    @JsonAlias("product_id")
    private Long productId;

    /**
     * 商品线上状态
     *
     * 0	初始值
     * 5	上架
     * 6	回收站
     * 9	逻辑删除
     * 11	自主下架
     * 12	售磬下架
     * 13	违规下架/风控系统下架
     */
    @JsonAlias("status")
    private Integer status;

    /**
     * 商品草稿状态
     *
     * 0	初始值
     * 1	编辑中
     * 2	审核中
     * 3	审核失败
     * 4	审核成功
     */
    @JsonAlias("edit_status")
    private Integer editStatus;

    /**
     * 商品SKU最小价格（单位：分）
     */
    @JsonAlias("min_price")
    private Long minPrice;

    /**
     * 商品分类
     */
    @JsonAlias("shopcat")
    private List<ShopCatDto> shopCat;

    /**
     * 小程序页面路径
     */
    private String path;

    /**
     * 商家自定义商品ID，与product_id二选一，需要自行保证单appid内唯一，一旦添加成功后该字段无法修改，最多32字符
     */
    @JsonProperty("out_product_id")
    protected String outProductId;

    /**
     * 标题，最多60字符
     */
    protected String title;

    /**
     * 副标题，最多18字符
     */
    @JsonProperty("sub_title")
    protected String subTitle;

    /**
     * 主图，多张，列表，最多9张
     */
    @JsonProperty("head_img")
    protected List<String> headImg;

    /**
     * 商品详情，图文(目前只支持图片，最多20张)
     */
    @JsonProperty("desc_info")
    protected SpuDescInfo descInfo;

    /**
     * 品牌ID，商家需要申请品牌并通过获取品牌接口brand/get获取，如果是无品牌请填2100000000
     */
    @JsonProperty("brand_id")
    protected String brandId;

    /**
     * 类目
     */
    @JsonProperty("cats")
    protected List<CategoryLevelDto> cats;

    /**
     * 属性
     */
    protected List<AttrItem> attrs;

    /**
     * 商品型号
     */
    protected String model;

    /**
     * 运费
     */
    @JsonProperty("express_info")
    protected ExpressInfo expressInfo;

    /**
     * skus 列表
     */
    protected List<SkuItem> skus;

    /**
     * 1-实物商品 2-券码商品。不填默认为实物商品。必须添加商品传入的类型保持一致，否则会返回参数错误。
     */
    @JsonProperty("product_type")
    protected Integer productType;

    /**
     * 核销设置
     */
    @JsonAlias("couponcode_info")
    private CouponCodeInfoResp couponcodeInfo;
}
