package cn.kinyun.scrm.weixin.sdk.entity.shop.dto;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @Desc
 * @Author zhangjing
 * @Date 2021/12/31 5:12 下午
 * @Version 1.0
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SkuItemDto {

    /**
     * 商家自定义商品ID，最多32字符
     */
    @JsonProperty("out_product_id")
    String outProductId;

    /**
     * 商家自定义skuID，最多32字符
     */
    @JsonProperty("out_sku_id")
    String outSkuId;

    /**
     * sku小图
     */
    @JsonProperty("thumb_img")
    String thumbImg;

    /**
     * 售卖价格，以分为单位，不超过1000000000（1000万元）
     */
    @JsonProperty("sale_price")
    Long salePrice;

    /**
     * 市场价格,以分为单位，不超过1000000000（1000万元），必须比sale_price大
     */
    @JsonProperty("market_price")
    Long marketPrice;

    /**
     * 库存
     */
    @JsonProperty("stock_num")
    Long stockNum;

    /**
     * 商品编码，最多20字符
     */
    @JsonProperty("sku_code")
    String skuCode;

    /**
     * 条形码
     */
    @JsonProperty("barcode")
    String barCode;

    /**
     * 属性
     */
    @JsonProperty("sku_attrs")
    List<AttrItem> skuAttrs;
}
