package cn.kinyun.scrm.weixin.sdk.entity.shop.dto;

import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.address.AddressInfo;
import com.fasterxml.jackson.annotation.JsonAlias;
import lombok.Data;

import java.util.List;

/**
 * @author zhangjing
 * @date 2022/1/4 4:55 下午
 */
@Data
public class DeliveryInfoDto {

    /**
     * 快递方式（目前只有"快递"）
     */
    @JsonAlias("delivery_method")
    private String deliveryMethod;

    /**
     * 发货时间
     */
    @JsonAlias("delivery_time")
    private String deliveryTime;

    @JsonAlias("delivery_product_info")
    private List<DeliveryProductInfo> deliveryProductInfos;

    @JsonAlias("address_info")
    private AddressInfo addressInfo;

    @JsonAlias("express_fee")
    private List<ExpressFee> expressFee;

    @JsonAlias("pickup_address")
    private PickUpAdderss pickUpAdderss;

    /**
     * 线下配送时间
     */
    @JsonAlias("offline_delivery_time")
    private Long offlineDeliveryTime;

    /**
     * 线下自提时间
     */
    @JsonAlias("offline_pickup_time")
    private Long offlinePickupTime;

    /**
     * 配送完成时间
     */
    @JsonAlias("ship_done_time")
    private Long shipDoneTime;
}
