package cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto.category;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @author zhangjing
 * @desc
 * @date 2022/1/21 10:25 下午
 */
@Data
public class CerticateItem {

    /**
     * 资质名称
     */
    @JsonProperty("key")
    private String key;

    /**
     * 资料图片URL
     */
    @JsonProperty("value")
    private String value;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(key), "key不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(value), "value不能为空");
    }

}
