/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.resp;

import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import com.fasterxml.jackson.annotation.JsonProperty;
import cn.kinyun.scrm.weixin.sdk.utils.MsgXmlBuilder;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 回复音乐消息
 * 
 * @title MusicMsg
 * @desc 回复音乐消息
 * @author yanmaoyuan
 * @date 2019年4月25日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class MusicMsg extends BaseRespMsg {

    private static final long serialVersionUID = -8816816022859229863L;

    /**
     * 音乐标题
     */
    private String title;

    /**
     * 音乐描述
     */
    private String description;

    /**
     * 音乐链接
     */
    @JsonProperty("musicurl")
    private String musicUrl;

    /**
     * 高质量音乐链接，WIFI环境优先使用该链接播放音乐
     */
    @JsonProperty("hqmusicurl")
    private String HQMusicUrl;

    /**
     * 缩略图的媒体id，通过素材管理中的接口上传多媒体文件，得到的id
     */
    @JsonProperty("thumb_media_id")
    private String thumbMediaId;

    public MusicMsg() {
        this.msgType = WxMsgType.Music.getValue();
    }

    @Override
    public String toXml() {

        MsgXmlBuilder builder = new MsgXmlBuilder(super.toXml());

        builder.append("<Music>");
        builder.addCData("Title", title);
        builder.addCData("Description", description);
        builder.addCData("MusicUrl", musicUrl);
        builder.addCData("HQMusicUrl", HQMusicUrl);
        builder.addCData("ThumbMediaId", thumbMediaId);
        builder.append("</Music>");
        builder.surroundWith("xml");

        return builder.toString();
    }

}