/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.req;

import cn.kinyun.scrm.weixin.sdk.entity.message.resp.MenuItem;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.MenuMsg;
import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 文本消息
 * 
 * @title TextReqMsg
 * @desc 文本消息
 * @author yanmaoyuan
 * @date 2019年4月24日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper=true)
public class TextReqMsg extends BaseReqMsg {

    private static final long serialVersionUID = 8771397437135650374L;

    /**
     * 文本消息内容
     */
    @JacksonXmlProperty(localName = "Content")
    private String content;

    /**
     * 用户点击的菜单ID
     * 
     * <p>客服在给用户发送消息时，若发送菜单消息，用户点击菜单后会给服务器推送一条消息。</p>
     * 
     * @see WxMsgType#MsgMenu
     * @see MenuMsg
     * @see MenuItem
     */
    @JacksonXmlProperty(localName = "bizmsgmenuid")
    private String bizMsgMenuId;
}