/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.req;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import cn.kinyun.scrm.weixin.sdk.entity.message.BaseMsg;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 接收普通消息
 * 
 * <p>当普通微信用户向公众账号发消息时，微信服务器将POST消息的XML数据包到开发者填写的URL上。</p>
 * <p>这个类中包含了所有消息中的公共字段。</p>
 * 
 * @title BaseReqMsg
 * @desc 接收普通消息
 * @author yanmaoyuan
 * @date 2019年4月24日
 * @version 1.0
 * @see <a href="https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140453">接收普通消息</a>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper=true)
public class BaseReqMsg extends BaseMsg {

    private static final long serialVersionUID = 7522414732555113652L;

    /**
     * 消息id，64位整型
     */
    @JacksonXmlProperty(localName = "MsgId")
    protected long msgId;
}