/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.mass.resp;

import com.fasterxml.jackson.annotation.JsonProperty;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 群发消息的速度
 * 
 * 
 * @title SendSpeed
 * @desc 群发消息的速度
 * @author yanmaoyuan
 * @date 2019年4月28日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class SendSpeed extends ErrorCode {

    private static final long serialVersionUID = 9126159164786446506L;

    /**
     * 群发速度的级别.
     * 
     * <p>群发速度的级别，是一个0到4的整数，数字越大表示群发速度越慢。</p>
     * 
     * <p>speed 与 realspeed 的关系如下：</p>
     * 
     * <table>
     * <tr><th>speed</th><th>realspeed</th></tr>
     * <tr><td>0</td><td>80w/分钟</td></tr>
     * <tr><td>1</td><td>60w/分钟</td></tr>
     * <tr><td>2</td><td>45w/分钟</td></tr>
     * <tr><td>3</td><td>30w/分钟</td></tr>
     * <tr><td>4</td><td>10w/分钟</td></tr>
     * <tr></tr>
     * </table>
     */
    private int speed;

    /**
     * 群发速度的真实值 单位：万/分钟
     */
    @JsonProperty("realspeed")
    private int realSpeed;
}
