/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.event.job;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.BaseEvent;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 事件推送-模板消息发送结果
 * 
 * <p>在模版消息发送任务完成后，微信服务器会将是否送达成功作为通知，发送到开发者中心中填写的服务器配置地址中。</p>
 * 
 * @title TemplateSendJobFinishEvent
 * @desc 事件推送-模板消息发送结果
 * @author yanmaoyuan
 * @date 2019年5月9日
 * @version 1.0
 * @see <a href="https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1433751277">事件推送</a>
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper = true)
public class TemplateSendJobFinishEvent extends BaseEvent {

    private static final long serialVersionUID = -2399753258838290053L;

    /**
     * 消息ID
     */
    @JacksonXmlProperty(localName = "MsgID")
    private String msgId;

    /**
     * <p>群发的结果，为:
     * 
     * <ul>
     * <li>success，发送成功</li>
     * <li>failed:user block，用户拒绝接收</li>
     * <li>failed: system failed，发送失败（非用户拒绝）</li>
     * </ul>
     */
    @JacksonXmlProperty(localName = "Status")
    private String status;
}