/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.event.job;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.BaseEvent;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 事件推送-群发消息发送结果
 * 
 * <p>
 * 由于群发任务提交后，群发任务可能在一定时间后才完成，因此，群发接口调用时，仅会给出群发任务是否提交成功的提示，若群发任务提交成功，则在群发任务结束时，会向开发者在公众平台填写的开发者URL（callback URL）推送事件。
 * </p>
 * 
 * <p>
 * 需要注意，由于群发任务彻底完成需要较长时间，将会在群发任务即将完成的时候，就推送群发结果，此时的推送人数数据将会与实际情形存在一定误差
 * </p>
 * 
 * <p>
 * 已增加原创校验结果.
 * </p>
 * 
 * @title MassSendJobFinishEvent
 * @desc 事件推送群发结果
 * @author yanmaoyuan
 * @date 2019年4月28日
 * @version 1.0
 * @see <a href="https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1481187827_i0l21">事件推送群发结果</a>
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper = true)
public class MassSendJobFinishEvent extends BaseEvent {

    private static final long serialVersionUID = -2765791835773987675L;

    /**
     * 群发的消息ID
     */
    @JacksonXmlProperty(localName = "MsgID")
    private String msgId;

    /**
     * <p>群发的结果，为“send success”或“send fail”或“err(num)”。但send success时，也有可能因用户拒收公众号的消息、系统错误等原因造成少量用户接收失败。</p>
     * 
     * err(num)是审核失败的具体原因，可能的情况如下：
     * <ul>
     * <li>err(10001), //涉嫌广告</li>
     * <li>err(20001), //涉嫌政治</li>
     * <li>err(20004), //涉嫌社会</li>
     * <li>err(20002), //涉嫌色情</li>
     * <li>err(20006), //涉嫌违法犯罪</li>
     * <li>err(20008), //涉嫌欺诈</li>
     * <li>err(20013), //涉嫌版权</li>
     * <li>err(22000), //涉嫌互推(互相宣传)</li>
     * <li>err(21000), //涉嫌其他</li>
     * <li>err(30001) // 原创校验出现系统错误且用户选择了被判为转载就不群发</li>
     * <li>err(30002) // 原创校验被判定为不能群发</li>
     * <li>err(30003) // 原创校验被判定为转载文且用户选择了被判为转载就不群发</li>
     * </ul>
     */
    @JacksonXmlProperty(localName = "Status")
    private String status;

    /**
     * tag_id下粉丝数；或者openid_list中的粉丝数
     */
    @JacksonXmlProperty(localName = "TotalCount")
    private Integer totalCount;

    /**
     * 过滤（过滤是指特定地区、性别的过滤、用户设置拒收的过滤，用户接收已超4条的过滤）后，准备发送的粉丝数，原则上，FilterCount = SentCount + ErrorCount
     */
    @JacksonXmlProperty(localName = "FilterCount")
    private Integer filterCount;

    /**
     *  发送成功的粉丝数
     */
    @JacksonXmlProperty(localName = "SentCount")
    private Integer sentCount;

    /**
     * 发送失败的粉丝数
     */
    @JacksonXmlProperty(localName = "ErrorCount")
    private Integer errorCount;

    /**
     * 原创验证结果
     */
    @JacksonXmlProperty(localName = "CopyrightCheckResult")
    private CopyrightCheckResult copyrightCheckResult;
}