/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.event.job;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import java.io.Serializable;

import lombok.Data;

/**
 * 文章原创版权校验结果
 * 
 * @title ArticleCheckResult
 * @desc 文章原创版权校验结果
 * @author yanmaoyuan
 * @date 2019年4月28日
 * @version 1.0
 */
@Data
public class ArticleCheckResult implements Serializable {

    private static final long serialVersionUID = 7248182447206474213L;

    /**
     * 群发文章的序号，从1开始
     */
    @JacksonXmlProperty(localName = "ArticleIdx")
    private int articleIdx;

    /**
     * 用户声明文章的状态
     */
    @JacksonXmlProperty(localName = "UserDeclareState")
    private int userDeclareState;

    /**
     * 系统校验的状态
     */
    @JacksonXmlProperty(localName = "AuditState")
    private int auditState;

    /**
     * 相似原创文的url
     */
    @JacksonXmlProperty(localName = "OriginalArticleUrl")
    private String originalArticleUrl;

    /**
     * 相似原创文的类型
     */
    @JacksonXmlProperty(localName = "OriginalArticleType")
    private int originalArticleType;

    /**
     * 是否能转载
     */
    @JacksonXmlProperty(localName = "CanReprint")
    private int canReprint;

    /**
     * 是否需要替换成原创文内容
     */
    @JacksonXmlProperty(localName = "NeedReplaceContent")
    private int needReplaceContent;

    /**
     * 是否需要注明转载来源
     */
    @JacksonXmlProperty(localName = "NeedShowReprintSource")
    private int needShowReprintSource;
}