package cn.kinyun.scrm.weixin.sdk.entity.message.event;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @ClassName PicSysPhotoEvent
 * @Description pic_sysphoto：弹出系统拍照发图的事件推送
 * @Author zhangjing
 * @DATE 2019/4/26 10:16
 * @Version 1.0
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class PicSysPhotoEvent extends BaseEvent {

    private static final long serialVersionUID = -10726448667350287L;

    @JacksonXmlProperty(localName = "EventKey")
    private String eventKey;

    /**
     * 发送的图片信息
     */
    @JacksonXmlProperty(localName = "SendPicsInfo")
    private SendPicsInfo sendPicsInfo;
}