/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.event;

import cn.kinyun.scrm.weixin.sdk.enums.WxEventType;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import cn.kinyun.scrm.weixin.sdk.entity.message.BaseMsg;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 接收事件推送
 * 
 * <p>
 * 在微信用户和公众号产生交互的过程中，用户的某些操作会使得微信服务器通过事件推送的形式通知到开发者在开发者中心处设置的服务器地址，从而开发者可以获取到该信息。其中，某些事件推送在发生后，是允许开发者回复用户的，某些则不允许，详细内容如下：
 * </p>
 * <ol>
 * <li>关注/取消关注事件</li>
 * <li>扫描带参数二维码事件</li>
 * <li>上报地理位置事件</li>
 * <li>自定义菜单事件</li>
 * <li>点击菜单拉取消息时的事件推送</li>
 * <li>点击菜单跳转链接时的事件推送</li>
 * </ol>
 * 
 * @title BaseEvent
 * @desc 接受用户事件的公共字段
 * @author yanmaoyuan
 * @date 2019年4月24日
 * @version 1.0
 * @see <a href="https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140454">接收事件推送</a>
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class BaseEvent extends BaseMsg {

    private static final long serialVersionUID = -4829050258747242898L;

    /**
     * 消息类型，event
     * 
     * @see WxEventType
     */
    @JacksonXmlProperty(localName = "Event")
    protected String event;
}