package cn.kinyun.scrm.weixin.sdk.entity.message.event;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import lombok.Data;

/**
 * @author Created by chenjiaqiang on 2022/01/22
 **/
@JacksonXmlRootElement(localName = "xml")
@Data
public class AppletAuditEvent {

    @JacksonXmlProperty(localName = "ToUserName")
    private String toUserName;

    /**
     * 发送方帐号（一个OpenID）
     */
    @JacksonXmlProperty(localName = "FromUserName")
    private String fromUserName;

    /**
     * 消息创建时间（整型）
     */
    @JacksonXmlProperty(localName = "CreateTime")
    private Long createTime;

    @JacksonXmlProperty(localName = "FailTime")
    private Long failTime;

    @JacksonXmlProperty(localName = "Event")
    private String event;

    @JacksonXmlProperty(localName = "Reason")
    private String reason;

    @JacksonXmlProperty(localName = "DelayTime")
    private Long delayTime;
}
