package cn.kinyun.scrm.weixin.sdk.entity.menu.dto;

import cn.kinyun.scrm.weixin.sdk.enums.menu.MenuButtonType;
import com.fasterxml.jackson.annotation.JsonProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @ClassName MenuButtonConf
 * @Description
 * @Author zhangjing
 * @DATE 2019/4/28 10:40
 * @Version 1.0
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper=true)
public class MenuButtonConf extends MenuButtonBase{

    /**
     * 必填字段
     * 菜单响应动作类型 {@link MenuButtonType}
     */
    @JsonProperty("type")
    String type;
    /**
     * click等点击类型必填
     *
     * 菜单KEY值，用于消息接口推送，不超过128字节
     */
    @JsonProperty("key")
    String key;

    /**
     * view、miniprogram类型必填
     *
     * 网页 链接，用户点击菜单可打开链接，不超过1024字节。 type为miniprogram时，不支持小程序的老版本客户端将打开本url。
     */
    @JsonProperty("url")
    String url;
    /**
     * miniprogram类型必填
     *
     * 小程序的appid（仅认证公众号可配置）
     */
    @JsonProperty("appid")
    String appId;
    /**
     * media_id类型和view_limited类型必须
     *
     * 调用新增永久素材接口返回的合法media_id
     */
    @JsonProperty("media_id")
    String mediaId;

    /**
     * 素材id
     * 
     * 注意：这个字段不是微信接口所需的参数，而是本系统的素材id
     */
    private Long matId;

    /**
     * miniprogram类型必须
     *
     * 小程序的页面路径
     */
    @JsonProperty("pagepath")
    String pagePath;
    /**
     * 二级菜单数组，个数应为1~5个
     */
    @JsonProperty("sub_button")
    SubButtonConf subButton;
    /**
     * 对于不同的菜单类型，value的值意义不同。
     * 官网上设置的自定义菜单： Text:保存文字到value；
     * Img、voice：保存mediaID到value；
     * Video：保存视频下载链接到value；
     * News：保存图文消息到news_info，同时保存mediaID到value；
     * View：保存链接到url。
     *
     * 使用API设置的自定义菜单：
     *  click、scancode_push、scancode_waitmsg、pic_sysphoto、pic_photo_or_album、 pic_weixin、location_select：保存值到key；
     *  view：保存链接到url
     */
    @JsonProperty("value")
    String value;

    /**
     * 图文消息的信息
     */
    @JsonProperty("news_info")
    NewsInfo newsInfo;

    /**
     * 素材类型
     */
    String mediaType; //自用
}
