/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.jssdk;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

import lombok.Data;

/**
 * JSSDK 对URL进行签名
 * 
 * @title UrlSignature
 * @desc JSSDK 对URL进行签名
 * @author yanmaoyuan
 * @date 2019年4月29日
 * @version 1.0
 */
@Data
public class UrlSignature implements Serializable {

    private static final long serialVersionUID = 5537118719753998370L;

    /**
     * 微信公众号的APPID
     */
    @JsonProperty("appid")
    private String appId;

    /**
     * 随机字符串，用于签名校验。
     */
    private String nonceStr;

    /**
     * 时间戳(单位：秒)
     */
    private String timestamp;

    /**
     * 需要签名的url
     */
    private String url;

    /**
     * 签名结果
     */
    private String signature;
}