/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.custom;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

import lombok.Data;

/**
 * 未接入会话
 * 
 * @title WaitCase
 * @desc 未接入会话
 * @author yanmaoyuan
 * @date 2019年5月5日
 * @version 1.0
 */
@Data
public class WaitCase implements Serializable {

    private static final long serialVersionUID = -3467791563153347898L;

    /**
     * 等待接待的粉丝id
     */
    @JsonProperty("openid")
    private String openId;
    
    /**
     *  粉丝的最后一条消息的时间，unix时间戳，单位：秒
     */
    @JsonProperty("latest_time")
    private long latestTime;
}