/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.custom;

import com.fasterxml.jackson.annotation.JsonProperty;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 在线客服列表
 * @title OnlineList
 * @desc 在线客服列表
 * @author yanmaoyuan
 * @date 2019年4月30日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class OnlineList extends ErrorCode {

    private static final long serialVersionUID = -7222998652098609592L;

    @JsonProperty("kf_online_list")
    private List<OnlineCustomAccount> list;
}