/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.custom;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

import lombok.Data;

/**
 * 客服正在服务的粉丝
 * 
 * @title Client
 * @desc 客服正在服务的粉丝
 * @author yanmaoyuan
 * @date 2019年5月5日
 * @version 1.0
 */
@Data
public class Client implements Serializable {

    private static final long serialVersionUID = 6057818310604727811L;

    /**
     * 正在接待的粉丝id
     */
    @JsonProperty("openid")
    private String openId;
    
    /**
     * 会话接入的时间，unix时间戳，单位：秒
     */
    @JsonProperty("createtime")
    private long createTime;
}