/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.account;

import com.fasterxml.jackson.annotation.JsonAlias;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 创建二维码的结果
 * 
 * @title CreateQrcodeResult
 * @author yanmaoyuan
 * @date 2019年7月25日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper= true)
public class CreateQrcodeResult extends ErrorCode {

    private static final long serialVersionUID = -7440435831459197777L;

    /**
     * 获取的二维码ticket，凭借此ticket可以在有效时间内换取二维码。
     */
    private String ticket;
    
    /**
     * 二维码图片解析后的地址，开发者可根据该地址自行生成需要的二维码图片
     */
    private String url;
    
    /**
     * 该二维码有效时间，以秒为单位。 最大不超过2592000（即30天）。
     */
    @JsonAlias("expire_seconds")
    private int expireSeconds;
}
