package com.kuaike.scrm.common.service.dto.req.customeracquisition;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.CustomerAcquisitionFkTypeEnum;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * @author Created by chenjiaqiang on 2023/05/17
 **/
@Data
public class UpdateSharePlanReq implements Serializable {

    private Integer fkType;
    private String weworkAllocRuleNum;

    private String addFriendRemark;

    private String welcomeContent;

    /**
     * xxx,xxx,xxx
     */
    private String tagIds;

    /**
     * 备注欢迎语标签是否生效，1生效
     */
    private Integer isAddFriendConfigEnable;

    public void validate() {
        Preconditions.checkArgument(fkType != null, "fkType不能为空");
        if (CustomerAcquisitionFkTypeEnum.AD.getType() == fkType) {
            // 广告是根据分配规则，修改这个分配规则下的所有欢迎语记录
            Preconditions.checkArgument(StringUtils.isNotBlank(weworkAllocRuleNum), "weworkAllocRuleNum不能为空");
        }
    }
}
