package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum TagAutoType {
    BUY_GOODS(1, "购买商品"),
    DATA_CHANNEL(2, "数据渠道"),
    CUSTOMER_BUSINESS_INFO(3, "客户业务信息");

    private final int type;
    private final String desc;

    TagAutoType(int type, String name) {
        this.type = type;
        this.desc = name;
    }

    public int getValue() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, TagAutoType> CACHE;

    static {
        CACHE = new HashMap<>(3);
        for (TagAutoType item : TagAutoType.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static TagAutoType get(Integer status) {
        return CACHE.get(status);
    }
}