package com.kuaike.scrm.common.service.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * @author louis
 * @date 2022/8/1
 */
@Data
public class ScrmRefreshTokenReq implements Serializable {


    private static final long serialVersionUID = 5287194172152207601L;

    private String corpId;

    private String accessToken;

    /**
     * 有效期
     */
    private Long expires;

    /**
     * 错误码
     */
    private Integer errCode;

    /**
     * 错误提示信息
     */
    private String errMsg;

    private Long updateUserId;


    public void validateForFresh() {
        Preconditions.checkArgument(StringUtils.isNotBlank(corpId), "corpId 不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(accessToken), "accessToken 不能为空");
    }

}
