package com.kuaike.scrm.common.service;

import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.service.dto.resp.ChatEsMsgResp;
import com.kuaike.scrm.common.service.dto.resp.ChatMsgAggResp;
import com.kuaike.scrm.common.service.dto.resp.ChatMsgRespDto;

import java.util.Collection;
import java.util.Date;
import java.util.List;

public interface ScrmChatMsgService {
    /**
     * 根据contactId查询客户聊天记录，只查询外部会话，单聊，action为send
     *
     * @param bizId 商户Id
     * @param contactIds 客户contatcId
     **/
    List<ChatMsgRespDto> queryChatMsgByContactId(Long bizId, List<String> contactIds);

    /**
     * 根据form 批量查询单聊消息
     * action = send
     * talkerType = 1
     * 且过滤文本内容为"我通过了你的联系人验证请求，现在我们可以开始聊天了"的消息
     */
    ChatEsMsgResp queryChatEsMsgByFromAndTime(Long bizId, Collection<String> fromList, Date startTime, Date endTime, PageDto pageDto);

    /**
     * 根据form 聚合查询单聊消息
     * action = send
     * talkerType = 1
     * 且过滤文本内容为"我通过了你的联系人验证请求，现在我们可以开始聊天了"的消息
     */
    List<ChatMsgAggResp> aggChatMsg(Long bizId, Collection<String> fromList, Date startTime, Date endTime);
}
