/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service;

import com.kuaike.scrm.common.service.dto.resp.AreaDto;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public interface AreaService {
    public static final int PROVINCE = 1;
    public static final int CITY = 2;
    public static final int REGION = 3;

    default public String getPrefix(String id) {
        if (id == null || id.length() != 6) {
            throw new IllegalArgumentException("invalid area id:" + id);
        }
        if (id.endsWith("0000")) {
            return id.substring(0, 2);
        }
        if (id.endsWith("00")) {
            return id.substring(0, 4);
        }
        return id;
    }

    default public boolean isChild(String parentCode, String childCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{parentCode, childCode})) {
            throw new IllegalArgumentException("invalid area id");
        }
        String prefix = this.getPrefix(parentCode);
        return childCode.startsWith(prefix);
    }

    default public int getLevel(String id) {
        if (id == null || id.length() != 6) {
            throw new IllegalArgumentException("invalid area id:" + id);
        }
        if (id.endsWith("0000")) {
            return 1;
        }
        if (id.endsWith("00")) {
            return 2;
        }
        return 3;
    }

    default public String getProvinceId(String id) {
        if (id == null || id.length() != 6) {
            throw new IllegalArgumentException("invalid area id:" + id);
        }
        if (id.endsWith("0000")) {
            return id;
        }
        return id.substring(0, 2) + "0000";
    }

    default public String getCityId(String id) {
        if (id == null || id.length() != 6) {
            throw new IllegalArgumentException("invalid area id:" + id);
        }
        if (id.endsWith("0000")) {
            throw new IllegalArgumentException("Can't get parent city of a province:" + id);
        }
        if (id.endsWith("00")) {
            return id;
        }
        return id.substring(0, 4) + "00";
    }

    public String getName(String var1);

    public Map<String, String> getNames(Collection<String> var1);

    public String getFullName(String var1);

    public Map<String, String> getFullNames(Collection<String> var1);

    public List<String> getChildrenIds(String var1, boolean var2);

    public List<String> getDirectChildrenIds(String var1, boolean var2);

    public Map<String, List<String>> getDirectChildrenIds(List<String> var1, boolean var2);

    public List<AreaDto> getProvince();

    public List<AreaDto> getChildren(String var1);

    public Map<String, AreaDto> getAll();

    default public String getMobileSegment(String mobile) {
        if (StringUtils.isBlank((CharSequence)mobile) || mobile.length() < 7) {
            return null;
        }
        return mobile.substring(0, 7);
    }

    public String getIdByMobile(String var1);

    public Map<String, String> getIdByMobiles(Collection<String> var1);
}

