package com.kuaike.scrm.common.service;


import com.kuaike.scrm.common.service.dto.CustomerDto;
import com.kuaike.scrm.common.service.dto.resp.BatchPhoneDto;

import java.util.List;

/**
 * @author lanye
 */
public interface CachePhoneService {

    /**
     * 获取手机号批次id
     *
     * @param phone
     * @return
     */
    BatchPhoneDto batchIdByPhone(String phone);

    /**
     * 获取手机号批次id
     *
     * @param phones
     * @return
     */
    BatchPhoneDto batchIdByPhone(List<String> phones);

    /**
     * 获取客户批次id
     *
     * @param customers
     * @return
     */
    BatchPhoneDto batchIdByCustomer(List<CustomerDto> customers);

    /**
     * 获取客户批次id
     *
     * @param customers
     * @return
     */
    BatchPhoneDto batchIdByCustomer(CustomerDto customers);

    /**
     * 获取客户
     *
     * @param num
     * @return
     */
    List<CustomerDto> getCustomer(String num);

    void deleteCustomerCache(String num);

}
